<?xml version="1.0" encoding="UTF-8"?>
<!-- Genere une requete DASL a partir d'un noeud DASLProp.
	parametres : 
			- staging : url du serveur webdav et du noeud d'entree
			- upnode  : noeud d'entree
			- depth   : profondeur de la recherche 
  -->

<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:param name="staging" />
<xsl:param name="upnode" />
<xsl:param name="depth" />

<xsl:template match="DASLProp">
<dasl:query xmlns:dasl="http://cocoon.apache.org/webdav/dasl/1.0" target="{$staging}/">
 	<D:searchrequest xmlns:D="DAV:">
 		<D:basicsearch>
 			<D:select> 
				<D:allprop/> 
			</D:select> 
			<D:from>
 				<D:scope>
 					<D:href>/<xsl:value-of select="$upnode" />/</D:href>
 					<D:depth><xsl:value-of select="$depth" /></D:depth>
				</D:scope>
			</D:from>
			<D:where>
				<D:eq>
					<D:prop>
						<D:getcontenttype/>
					</D:prop>
					<D:literal>text/html</D:literal>
				</D:eq>
			</D:where>
			<D:orderby>
				<D:order>
 					<D:prop><D:getcontentlength/></D:prop>
					<D:ascending/>
				</D:order>
				<D:order>
					<D:prop><D:href/></D:prop>
					<D:ascending/>
				</D:order>
			</D:orderby>
		</D:basicsearch>
	</D:searchrequest>
</dasl:query>
</xsl:template>
</xsl:stylesheet> 